VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "C_GenericFunctions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Public Sub ITExpenditureLoad(ByRef lo_Components As Collection)
Dim ls_Req As String
Dim ll_Statement As Long
Dim li_Status As Integer
Dim lb_Approbator As Boolean

    lb_Approbator = KO

    On Error GoTo ITExpenditureLoad_Err

    ls_Req = "EXEC IT_Location_cbo '" & prg.LoginName & "'"
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
        li_Status = SQLFetch(ll_Statement)
        Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
            If ODBCData(ll_Statement, 5) = "Y" Then
                lb_Approbator = OK
            End If
            li_Status = SQLFetch(ll_Statement)
        Loop
        SQLFreeStatement ll_Statement, SQL_DROP
    End If

ITExpenditureLoad_Err:
    If lb_Approbator = OK Then
        MCombo_AddItemCode lo_Components("cbo_View"), 5, "Waiting", OK
    Else
        MCombo_AddItemCode lo_Components("cbo_View"), 1, "All", OK
    End If

End Sub

Public Sub CallITOutline(ByRef lo_Components As Collection)
Dim ls_ITOutline As New IT_OutLine

    gs_TableName = "IT_Expenditure"
    gs_ParamReqCsts = "EXEC Screen_Csts 'out_IT_Expend'"
    ls_ITOutline.show 1
    
End Sub

Public Sub CallITExpenditureAdd(ByRef lo_Components As Collection)
Dim lo_ITExpenditure As New IT_Expend_mtnc

    gs_TableName = "IT_Expenditure"
    gs_Action = "Add"
    gs_ParamReqCsts = "EXEC Screen_Csts 'mtnc_It_Expend'"
    gs_ParamReqIns = "EXEC IT_Expenditure_ins "
    
    lo_ITExpenditure.show 1
    
    Screen.ActiveForm.Refresh_Screen "Grd_Main"
    
    lo_Components("cbo_Year").Tag = UNLOADED
    
End Sub

Public Sub ITExpenditureUpdate(ByRef lo_Components As Collection)
Dim lo_ITExpenditure As New IT_Expend_mtnc
Dim lo_Grid As Object
Dim ll_Line As Long

    Set lo_Grid = lo_Components("Grd_Main")
    
    If lo_Grid.TextMatrix(lo_Grid.Row, 1) = "" Then
        SendMessage 1, "Select a record first, please", gut_LangLogin.Code
        Exit Sub
    End If

    gs_TableName = "IT_Expenditure"
    gs_TableCode = Str(lo_Grid.TextMatrix(lo_Grid.Row, 0))
    gs_TableCode9 = Str(lo_Grid.TextMatrix(lo_Grid.Row, 38))
    gs_Action = "Update"
    gs_ParamReqCsts = "EXEC Screen_Csts 'mtnc_It_Expend'"
    gs_ParamReqUpd = "EXEC IT_Expenditure_upd "

    lo_ITExpenditure.show 1
    
    If gb_Return = OK Then
        If MCombo_GetCode(lo_Components("cbo_view")) <> 1 Then
            Screen.ActiveForm.Refresh_Screen "Grd_Main"
        Else
            ll_Line = lo_Grid.Row
        
            lo_Grid.TextMatrix(ll_Line, 3) = lo_ITExpenditure.cbo_Location.Text
            If lo_ITExpenditure.opt_CapExp(0).value = OK Then
                lo_Grid.TextMatrix(ll_Line, 4) = "Capital"
            Else
                lo_Grid.TextMatrix(ll_Line, 4) = "Expenses"
            End If
            lo_Grid.TextMatrix(ll_Line, 5) = lo_ITExpenditure.txt_Order_nb.Text
            lo_Grid.TextMatrix(ll_Line, 7) = lo_ITExpenditure.Txt_Cat.Text
            lo_Grid.TextMatrix(ll_Line, 9) = lo_ITExpenditure.Cbo_SubCat.Text
            lo_Grid.TextMatrix(ll_Line, 11) = lo_ITExpenditure.cbo_Project.Text
            If lo_ITExpenditure.Opt_AppRef(0).value = OK Then
                lo_Grid.TextMatrix(ll_Line, 12) = "Approved"
            Else
                If lo_ITExpenditure.Opt_AppRef(1).value = OK Then
                    lo_Grid.TextMatrix(ll_Line, 12) = "Refused"
                Else
                    If lo_ITExpenditure.Opt_AppRef(2).value = OK Then
                        lo_Grid.TextMatrix(ll_Line, 12) = "OnHold"
                    Else
                        lo_Grid.TextMatrix(ll_Line, 12) = ""
                    End If
                End If
            End If
            lo_Grid.TextMatrix(ll_Line, 15) = lo_ITExpenditure.txt_Approval_date.GetFrDate
            lo_Grid.TextMatrix(ll_Line, 22) = lo_ITExpenditure.Txt_O_Amount_USD.Text
            lo_Grid.TextMatrix(ll_Line, 26) = lo_ITExpenditure.cbo_Order_by.Text
            lo_Grid.TextMatrix(ll_Line, 38) = lo_Grid.TextMatrix(ll_Line, 38) + 1
        
            lo_Components("cbo_Year").Tag = UNLOADED
        End If
    End If
    
End Sub

Public Sub ITExpenditureDelete(ByRef lo_Components As Collection)
Dim lo_ITExpenditure As New IT_Expend_mtnc
Dim i, j As Long

    If lo_Components("grd_Main").TextMatrix(lo_Components("grd_Main").Row, 1) = "" Then
        SendMessage 1, "Select a record first, please", gut_LangLogin.Code
        Exit Sub
    End If

    gs_TableName = "IT_Expenditure"
    gs_TableCode = Str(lo_Components("Grd_Main").TextMatrix(lo_Components("Grd_Main").Row, 0))
    gs_TableCode9 = Str(lo_Components("Grd_Main").TextMatrix(lo_Components("Grd_Main").Row, 38))
    gs_Action = "Delete"
    gs_ParamReqCsts = "EXEC Screen_Csts 'mtnc_It_Expend'"
    gs_ParamReqDel = "EXEC IT_Expenditure_del "
    
    lo_ITExpenditure.show 1
    
    If gb_Return = OK Then
        lo_Components("Grd_Main").RemoveItem lo_Components("Grd_Main").Row
        lo_Components("cbo_Year").Tag = UNLOADED
    End If
    
End Sub

Public Sub ITExpenditureChangeView(ByRef lo_Components As Collection)

    MouseOff
    If MCombo_GetCode(lo_Components("cbo_View")) = 6 Then
        Set lo_Components("Cbo_SubCat").SelectedItem = Nothing
        lo_Components("Cbo_SubCat").Text = ""
        lo_Components("lbl_SubCat").Visible = OK
        lo_Components("cbo_SubCat").Visible = OK
    Else
        Set lo_Components("Cbo_SubCat").SelectedItem = Nothing
        lo_Components("Cbo_SubCat").Text = ""
        lo_Components("lbl_SubCat").Visible = KO
        lo_Components("cbo_SubCat").Visible = KO
        Screen.ActiveForm.Refresh_Screen "Grd_Main"
    End If
    MouseOn
End Sub

Public Sub ITExpenditurePreview(ByRef lo_Components As Collection)
Dim lo_ITExpenditure As New IT_Expend_mtnc

    gs_TableName = "IT_Expenditure"
    gs_TableCode = Str(lo_Components("Grd_Main").TextMatrix(lo_Components("Grd_Main").Row, 0))
    gs_Action = "MoreInfo"
    gs_ParamReqCsts = "EXEC Screen_Csts 'mtnc_It_Expend'"
    
    lo_ITExpenditure.show 1
    
    lo_Components("cbo_Year").Tag = UNLOADED
    
End Sub

Public Sub ITExpenditureRefresh(ByRef lo_Components As Collection)
Dim i As Integer
Dim ls_TotalExpense As String
Dim ls_TotalCapital As String
    '4: Cap/Exp
    '22: USD Amount
    ls_TotalExpense = "0.00"
    ls_TotalCapital = "0.00"
    
    For i = 1 To lo_Components("Grd_Main").Rows - 1
        If lo_Components("Grd_Main").TextMatrix(i, 4) = "Capital" Then
            ls_TotalCapital = Formatage(Formatage2(Round(Val(lo_Components("Grd_Main").TextMatrix(i, 22)) + Val(ls_TotalCapital), 2)), 2)
        Else
            ls_TotalExpense = Formatage(Formatage2(Round(Val(lo_Components("Grd_Main").TextMatrix(i, 22)) + Val(ls_TotalExpense), 2)), 2)
        End If
    Next
    
    lo_Components("txt_CapitalTotal").Text = ls_TotalCapital
    lo_Components("txt_ExpensesTotal").Text = ls_TotalExpense
    
End Sub

